#!/usr/bin/python3
# -*- coding: utf-8 -*-
########################################################## {COPYRIGHT-TOP} ###
# Licensed Materials - Property of IBM
# PRD0012491
#
# (C) Copyright IBM Corp. 2023
#
# US Government Users Restricted Rights - Use, duplication, or
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
########################################################## {COPYRIGHT-END} ###
import argparse
import itdt_script as itdt
import os
from pathlib import Path

script_path = os.path.realpath(os.path.dirname(__file__))
itdt_path = Path(script_path + '/../itdt').resolve()
output_path = Path(script_path + '/../output').resolve()
tape = itdt.ITDT(itdt_path)

#Main starts here
#Parsing arguments
parser = argparse.ArgumentParser(
    prog='Mount cartridges script',
    description='IBM script to mount cartridges from I/O slot to first empty storage slots.',)
parser.add_argument('-c','--changer', type=str, required=True, help='The special device file of the IBM library.')
args = parser.parse_args()

changer_device = args.changer

print ('Check for cartridges in I/O slots and move them to the first available storage slot...')
#device_list = tape.scan_devices()


# 1. Read the element infos
result, data = tape.run_commands(changer_device, 'elementinfoj', True)
if result != 0:
    print (f'{changer_device} could not be opened: {data}')   
    quit(-1)
else:
    #number_of_io_elements = data[0]['numberOfIOElements']
    element_info = data[0]
    io_elements = element_info['numberOfIOElements']
    io_first_address = element_info['firstIOAddress']
    
    #2. Get the inventory
    result, inventory = tape.run_commands(changer_device, 'invj', True)
    if result != 0:
        print (f'{changer_device} inventory failed: {data}')
        quit(-1)
    
    reserved_addresses=[]
    data_transfer_elements=None
    import_export_elements=None
    storage_elements=None
    #Separate the data types
    for elements in inventory:
        if elements['elementTypeName'] == 'Data Transfer':
            data_transfer_elements = elements['elements']
        if elements['elementTypeName'] == 'Import/Export':
            import_export_elements = elements['elements']
        if elements['elementTypeName'] == 'Storage':
            storage_elements = elements['elements']
            
    
    #print (f'DTE count is: {len(data_transfer_elements)}')
    #Check for loaded cartridges in drives to skip their source addresses
    for dte in data_transfer_elements:
        if dte['mediaPresent'] == 'Yes' and dte['sourceElementAddress'] != 0 and dte['sourceElementAddressValid'] == 'Yes':
            print (f"Skip address {dte['sourceElementAddress']}")
            reserved_addresses.append(dte['sourceElementAddress'])
    
    #Check for loaded cartridges in I/O
    for io_element in import_export_elements:
        if io_element['mediaPresent'] == 'Yes' and io_element['mediaInverted'] == 'No':
           print (f"Media found at I/O address {io_element['importExportStationAddress']}") 
           io_address = io_element['importExportStationAddress']
           for storage_element in storage_elements:
               if storage_element['mediaPresent'] != "Yes" and storage_element['mediumTransferAccessAllowed'] == "Yes" \
                and (storage_element['mediaPresent'] not in reserved_addresses):
                    storage_address = storage_element['slotAddress']
                    print (f"Move cartridge from I/O {io_address} to Storage {storage_address} ...",end='', flush=True)
                    reserved_addresses.append(storage_address)
                    command_str = 'move ' + str(io_address) + ' ' + str(storage_address)
                    result, data = tape.run_commands(changer_device, command_str)
                    if result == 0:
                       print ('Passed.')
                       storage_element['mediaPresent'] = "Yes"
                    else:
                        print ('Failed.')
                        print ("Error: ", data)
                    break

    print ("... script end.")



